/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.common.vo;

import com.bxm.egg.common.constant.RespCode;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(description="\u6807\u51c6\u7684Json\u54cd\u5e94\u683c\u5f0f\u6570\u636e")
@Deprecated
public class Json<T> {
    @ApiModelProperty(required=true, value="\u64cd\u4f5c\u7ed3\u679c\u7f16\u7801", example="0/400/401/403/404/500")
    private int code;
    @ApiModelProperty(value="\u8bf7\u6c42\u7684\u8fd4\u56de\u6d88\u606f\uff0ccode\u4e3a0\u53ef\u80fd\u4e3a\u7a7a\uff0c\u5176\u4ed6code\u5747\u6709\u503c", example="\u64cd\u4f5c\u5b8c\u6210/\u64cd\u4f5c\u6210\u529f/\u4f59\u989d\u4e0d\u8db3...")
    private String errorMsg = "";
    @ApiModelProperty(value="\u8bf7\u6c42\u7684\u8fd4\u56de\u6570\u636e\uff0c\u6839\u636e\u8bf7\u6c42\u4e0d\u540c\u6709\u5177\u4f53\u7684\u8fd4\u56de\u5b9e\u4f53")
    private T result;

    private Json() {
        this.code = 0;
    }

    private Json(int code) {
        this.code = code;
    }

    private Json(int code, String errorMsg) {
        this.code = code;
        this.errorMsg = errorMsg;
    }

    private Json(Message message) {
        this.code = message.isSuccess() ? 0 : RespCode.BAD_REQUEST;
        this.errorMsg = message.getLastMessage();
    }

    private Json(int code, String errorMsg, T result) {
        this.code = code;
        this.errorMsg = errorMsg;
        this.result = result;
    }

    protected Json(Json<T> source) {
        this.code = source.code;
        this.errorMsg = source.errorMsg;
        this.result = source.result;
    }

    public static <T> Json<T> build() {
        return new Json<T>();
    }

    public static <T> Json<T> build(T result) {
        Json<T> json = new Json<T>();
        return json.setResult(result);
    }

    public static <T> Json<T> build(Message message) {
        return new Json<T>(message);
    }

    public static <T> Json<T> build(int code, String errorMsg) {
        return new Json<T>(code, errorMsg);
    }

    public static <T> Json<T> build(int code, String errorMsg, T result) {
        return new Json<T>(code, errorMsg, result);
    }

    public static <T> Json<T> ok(T result) {
        return new Json<T>().body(result);
    }

    public static <T> Json<T> ok() {
        return new Json<T>();
    }

    public static <T> Json<T> badReqeuset() {
        return new Json<T>(RespCode.BAD_REQUEST);
    }

    public static <T> Json<T> badReqeuset(String errorMsg) {
        return new Json<T>(RespCode.BAD_REQUEST, errorMsg);
    }

    public static <T> Json<T> serverError() {
        return new Json<T>(RespCode.INTERNAL_SERVER_ERROR);
    }

    public static <T> Json<T> serverError(String errorMsg) {
        return new Json<T>(RespCode.INTERNAL_SERVER_ERROR, errorMsg);
    }

    public static <T> Json<T> unauthorized() {
        return new Json<T>(RespCode.UNAUTHORIZED);
    }

    public static <T> Json<T> unauthorized(String errorMsg) {
        return new Json<T>(RespCode.UNAUTHORIZED, errorMsg);
    }

    public boolean success() {
        return this.code == 0;
    }

    public int getCode() {
        return this.code;
    }

    public Json<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Json<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public Json<T> body(T result) {
        this.result = result;
        return this;
    }

    public T getResult() {
        return this.result;
    }

    public Json<T> setResult(T result) {
        this.result = result;
        return this;
    }

    public Json<T> output() {
        return new Json<T>(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

