package com.bxm.egg.common.enums;

import java.util.Objects;

/**
 * 用户类型枚举
 *
 * @author liujia
 * @date 9/13/21 8:50 PM
 **/
public enum UserTypeEnum {

    /**
     * 临时用户（静默用户）
     */
    TEMP(0),

    /**
     * 正常用户
     */
    NORMAL(1),

    /**
     * 虚拟用户
     */
    VIRTUAL(2),

    /**
     * 测试用户
     */
    TEST(2),
    ;

    /**
     * 用户状态是否为正常用户
     *
     * @param status 用户状态
     * @return true表示为正常用户
     */
    public static boolean isNormal(int status) {
        return NORMAL.getCode() == status;
    }

    public boolean match(int status) {
        return Objects.equals(status, this.code);
    }

    private int code;

    public int getCode() {
        return this.code;
    }

    UserTypeEnum(int code) {
        this.code = code;
    }
}
