package com.bxm.egg.common.sharding;

import com.bxm.egg.common.vo.IEquipmentSharding;
import com.google.code.shardbatis.strategy.ShardStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 设备分表策略
 */
public class EquipmentStrategy implements ShardStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(EquipmentStrategy.class);

    @Override
    public String getTargetTableName(String baseTableName, Object params, String mapperId) {
        if (params instanceof IEquipmentSharding) {
            IEquipmentSharding sharding = (IEquipmentSharding) params;
            if (sharding.getId() == null) {
                LOGGER.error("根据设备id进行分表，必须有值");
            } else {
                return getTableName(sharding.getId(), baseTableName);
            }
        } else if (params instanceof String) {
            return getTableName((String) params, baseTableName);
        } else if (params instanceof Map) {
            Map<String, Object> paramMap = (Map<String, Object>) params;
            Object id = paramMap.get("id");
            if (id instanceof String) {
                return getTableName((String) id, baseTableName);
            } else {
                LOGGER.error("根据设备id进行分表，Map类型参数中必须有键名为[id]的值，而且类型为String");
            }
        } else {
            LOGGER.error("[{}][{}]已分表，参数支持[{}]或[Long]，请修改", mapperId, baseTableName, IEquipmentSharding.class);
        }
        return baseTableName;
    }

    private String getTableName(String id, String baseTableName) {
        int hashcode = Math.abs(id.hashCode());
        return baseTableName + "_" + (hashcode % 10);
    }

}