package com.bxm.egg.common.url;

import com.bxm.egg.common.constant.AppConst;
import com.bxm.foundation.base.facade.enums.DomainScene;
import com.bxm.foundation.base.facade.enums.DomainViewScene;
import com.bxm.foundation.base.facade.param.DomainFetchParam;
import com.bxm.foundation.base.facade.service.DomainFacadeService;

/**
 * 商户 - 商品详情地址
 *
 * @author liujia
 * @date 1/22/21 1:58 PM
 **/
public class GoodsDetailProtocolBuilder extends AbstractProtocolBuilder {
    GoodsDetailProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 构建站内分享地址
     */
    public InnerProtocolBuilder inner() {
        return new InnerProtocolBuilder();
    }

    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    public class OuterProtocolBuilder {

        private Long goodsId;

        private String areaCode;

        private String areaName;

        private Long inviterId;

        public OuterProtocolBuilder goodsId(Long goodsId) {
            this.goodsId = goodsId;
            return this;
        }

        public OuterProtocolBuilder inviterId(Long inviterId) {
            this.inviterId = inviterId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder areaName(String areaName) {
            this.areaName = areaName;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getBaseUrlInfo(DomainFetchParam.builder()
                    .srcApp(AppConst.SRC_APP)
                    .scene(DomainScene.OUTSIDE_SHARE)
                    .viewScene(DomainViewScene.WX_JS_VIEW)
                    .build());

            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/tk/goods.html#/wx/detail?goodsId=").append(goodsId);

            if (inviterId != null) {
                url.append("&inviterId=").append(inviterId);
            }
            if (areaCode != null) {
                url.append("&areaCode=").append(areaCode);
            }
            if (areaName != null) {
                url.append("&areaName=").append(areaName);
            }

            return url.toString();
        }
    }

    public class InnerProtocolBuilder {

        private Long goodsId;

        private Long userId;

        private boolean enablePlaceHolder = false;

        public InnerProtocolBuilder enablePlaceHolder() {
            this.enablePlaceHolder = true;
            return this;
        }

        public InnerProtocolBuilder goodsId(Long goodsId) {
            this.goodsId = goodsId;
            return this;
        }

        public InnerProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getInnerH5BaseUrl(AppConst.SRC_APP);
            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/tk/goods.html#/details?goodsId=").append(goodsId);

            if (null != userId) {
                url.append("&userId=").append(userId);
            }
            if (enablePlaceHolder) {
                url.append("&areaCode={areaCode}")
                        .append("&areaName={areaName}")
                        .append("&lng={lng}")
                        .append("&lat={lat}");

                if (null == userId) {
                    url.append("&userId={userId}");

                }
            }

            return url.toString();
        }
    }
}
