package com.bxm.egg.common.constant;

import org.springframework.http.HttpStatus;

/**
 * 服务端响应编码，前端用于判断请求是否成功
 *
 * @author liujia
 * @deprecated 不再使用，仅用于兼容旧代码
 */
@Deprecated
public class RespCode {

    /**
     * 200:请求成功,遗留问题所以使用0
     */
    public final static int OK = 0;

    /**
     * 400:请求不可用（参数错误、不完整等）
     */
    public static final int BAD_REQUEST = HttpStatus.BAD_REQUEST.value();

    /**
     * 401:请求的资源需要登录后才能访问
     */
    public final static int UNAUTHORIZED = HttpStatus.UNAUTHORIZED.value();

    /**
     * 403:无权访问
     */
    public final static int FORBIDDEN = HttpStatus.FORBIDDEN.value();

    /**
     * 404:请求不存在
     */
    public final static int NOT_FOUND = HttpStatus.NOT_FOUND.value();

    /**
     * 405:请求的方法不支持
     */
    public final static int METHOD_NOT_ALLOWED = HttpStatus.METHOD_NOT_ALLOWED.value();

    /**
     * 500：服务器内部错误
     */
    public final static int INTERNAL_SERVER_ERROR = HttpStatus.INTERNAL_SERVER_ERROR.value();

    /**
     * 1000：token过期
     *
     * @deprecated 不推荐将返回码与业务强绑定，此处为遗留问题
     */
    public final static int TOKEN_TIMEOUT = 1000;

    /**
     * 512：用户注册后如果未绑定手机号码返回此编码
     *
     * @deprecated 不推荐将返回码与业务强绑定，此处为遗留问题
     */
    public final static int BIND_PHONE = 512;

}
