package com.bxm.egg.common.url;

import com.bxm.foundation.base.facade.service.DomainFacadeService;

/**
 * 评论和点赞综合页面协议
 *
 * @author liujia
 * @date 1/20/21 5:06 PM
 **/
public class CommentOrLikeTabProtocolBuilder extends AbstractProtocolBuilder {

    CommentOrLikeTabProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    public AppProtocolBuilder comment() {
        return new AppProtocolBuilder().tableIndex(0);
    }

    public AppProtocolBuilder like() {
        return new AppProtocolBuilder().tableIndex(1);
    }

    public class AppProtocolBuilder {
        private Integer tableIndex = 0;

        public AppProtocolBuilder tableIndex(Integer tableIndex) {
            this.tableIndex = tableIndex;
            return this;
        }

        public String build() {
            return "egg://message/commentLike?selectedTab=" + tableIndex;
        }
    }
}
