package com.bxm.egg.common.url;

import com.bxm.foundation.base.facade.service.DomainFacadeService;

/**
 * 群聊的相关协议构建
 *
 * @author liujia
 * @date 1/20/21 3:06 PM
 **/
public class GroupChatProtocolBuilder extends AbstractProtocolBuilder {

    GroupChatProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 构建帖子的站内访问协议地址
     */
    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public class AppProtocolBuilder {
        private Long groupId;

        public AppProtocolBuilder groupId(Long groupId) {
            this.groupId = groupId;
            return this;
        }

        public String build() {
            return "egg://im/imChatRoom?chatRoomId=" + groupId;
        }
    }
}
