package com.bxm.egg.common.url;

import com.bxm.foundation.base.facade.service.DomainFacadeService;

/**
 * 消息中心的相关协议构建
 *
 * @author liujia
 * @date 1/20/21 3:06 PM
 **/
public class MessageCenterProtocolBuilder extends AbstractProtocolBuilder {

    MessageCenterProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 消息中心的消息列表
     *
     * @return
     */
    public AppProtocolBuilder list() {
        return new AppProtocolBuilder();
    }

    public class AppProtocolBuilder {
        private String title;

        private String type;

        public AppProtocolBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AppProtocolBuilder type(String type) {
            this.type = type;
            return this;
        }

        public String build() {
            return "egg://message/messageList?title=" + encode(title) + "&type=" + type;
        }
    }
}
