package com.bxm.egg.common.url;

import com.bxm.egg.common.constant.AppConst;
import com.bxm.foundation.base.facade.enums.DomainScene;
import com.bxm.foundation.base.facade.enums.DomainViewScene;
import com.bxm.foundation.base.facade.param.DomainFetchParam;
import com.bxm.foundation.base.facade.service.DomainFacadeService;
import org.apache.dubbo.common.utils.StringUtils;

/**
 * 帖子的相关协议构建
 *
 * @author liujia
 * @date 1/20/21 3:06 PM
 **/
public class PostProtocolBuilder extends AbstractProtocolBuilder {

    PostProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 构建帖子的站外分享地址
     */
    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    /**
     * 构建帖子的站内访问协议地址
     */
    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public class OuterProtocolBuilder {

        private Long postId;

        private Long userId;

        private String areaCode;

        private String cityName;

        private boolean noExtend;

        private String channel;

        /**
         * 管理后台用：为true不上报奖励
         */
        private boolean debug;

        private DomainViewScene domainViewScene = DomainViewScene.WX_JS_VIEW;

        public OuterProtocolBuilder noExtend() {
            this.noExtend = true;
            return this;
        }

        public OuterProtocolBuilder debug() {
            this.debug = true;
            return this;
        }

        public OuterProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public OuterProtocolBuilder postId(Long postId) {
            this.postId = postId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder cityName(String cityName) {
            this.cityName = cityName;
            return this;
        }

        public OuterProtocolBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public OuterProtocolBuilder domainViewScene(DomainViewScene domainViewScene) {
            this.domainViewScene = domainViewScene;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getBaseUrlInfo(DomainFetchParam.builder()
                    .srcApp(AppConst.SRC_APP)
                    .scene(DomainScene.OUTSIDE_SHARE)
                    .viewScene(domainViewScene)
                    .build());

            if (!DomainViewScene.CONTENT_VIEW.equals(domainViewScene) && StringUtils.isBlank(baseUrl)) {
                baseUrl = domainIntegrationService.getBaseUrlInfo(DomainFetchParam.builder()
                        .srcApp(AppConst.SRC_APP)
                        .scene(DomainScene.OUTSIDE_SHARE)
                        .viewScene(DomainViewScene.CONTENT_VIEW)
                        .build());
            }

            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("egg/posts.html#/postDetail?id=").append(postId);

            if (null != userId) {
                url.append("&userId=").append(userId);
            }
            if (null != areaCode) {
                url.append("&areaCode=").append(areaCode);
            }
            if (null != cityName) {
                url.append("&cityName=").append(cityName);
            }
            if (null != channel) {
                url.append("&channel=").append(channel);
            }
            if (noExtend) {
                url.append("&noExtend=1");
            }
            if (debug) {
                url.append("&debug=true");
            }

            return url.toString();
        }
    }

    public class AppProtocolBuilder {
        private Long postId;

        public AppProtocolBuilder postId(Long postId) {
            this.postId = postId;
            return this;
        }

        public String build() {
            return "egg://community/postDetail?postId=" + postId + "&tp=post";
        }
    }
}
