package com.bxm.egg.mq.common.constant;

import static com.bxm.egg.mq.common.constant.SmsTemplateTypeEnum.V_CODE;

/**
 * Created by Arei on 2018/10/11.
 * 短信模版常量类，存放包括短信模版的所有配置（内容，发送次数限制，模版类型，参数个数等）
 *
 * @author Arei
 */
public enum SmsTemplateEnum {
    /**
     * 登录模版
     */
    LOGIN("您本次登录的验证码为{}，有效期为10分钟，请勿泄露给他人！", V_CODE, 1),

    /**
     * 绑定号码模版
     */
    BINDING_PHONE("您正在绑定手机号码，验证码为{}，有效期为10分钟，请勿泄露给他人！", V_CODE, 2),

    /**
     * 注册模版
     */
    REGISTER("尊敬的用户，您的注册验证码为{}", V_CODE, 3),

    /**
     * 重置密码模版
     */
    RESET_PWD("尊敬的用户，您正在进行重置密码，验证码是{}，请勿泄露！", V_CODE, 6),

    /**
     * 普通验证码（商户，蓝领）
     */
    NORMAL_V_CODE("您的验证码:{}，请不要告诉他人。", V_CODE, 7);

    /**
     * 短信内容
     */
    private String content;

    /**
     * 短信模版类型（验证码/其他...）
     */
    private SmsTemplateTypeEnum type;

    private int code;

    SmsTemplateEnum(String content,
                    SmsTemplateTypeEnum type,
                    int code) {

        this.content = content;
        this.type = type;
        this.code = code;
    }

    public String getContent() {
        return content;
    }

    public int getCode() {
        return code;
    }

    public static SmsTemplateEnum getByCode(int code) {
        for (SmsTemplateEnum templateEnum : SmsTemplateEnum.values()) {
            if (templateEnum.getCode() == code) {
                return templateEnum;
            }
        }

        return null;
    }

    /**
     * 校验模版是否是验证码类型模版，用于调用者调用发送验证码类短信的方法的校验
     *
     * @return 是否为验证码类型的模板
     */
    public boolean isVCodeType() {
        return this.type == V_CODE;
    }
}
