package com.bxm.egg.mq.common.param;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

/**
 * 钉钉推送消息格式
 *
 * @author liujia
 * @date 2020-07-13 17:24
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class DingtalkMessage extends BaseBean {

    @Tolerate
    public DingtalkMessage() {

    }

    /**
     * 业务场景，用于匹配对应的接收机器人,该值与配置中保持一致
     * 如果为空则默认为运维消息
     */
    private String scene;

    /**
     * 推送的文字内容，后续可以完善参数
     */
    private String content;
}
