/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.mq.common.constant;

import com.bxm.egg.mq.common.constant.MessageBehaviorEnum;
import com.bxm.egg.mq.common.constant.MessageTypeEnum;
import com.bxm.newidea.component.tools.NumberUtils;

public enum PushMessageEnum {
    JUMP_TYPE(105, "\u65b0\u7248\u672c\u63a8\u9001\u9700\u8981\u8df3\u8f6c\u7684\u7c7b\u578b", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    SYSTEM_MSG(0, "\u7cfb\u7edf\u516c\u544a", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    ORDINARY_MSG(1, "\u63d0\u793a\u6d88\u606f", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    OPEN_URL(10, "\u6253\u5f00\u94fe\u63a5", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    PARTICIPATE_PRIVILEGE_SUCCESS(11, "\u53c2\u52a0\u6d3b\u52a8\u6210\u529f", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    PRIVILEGE_OPEN_PRIZE(12, "\u6d3b\u52a8\u5f00\u5956", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    PRIVILEGE_WINNING(13, "\u6d3b\u52a8\u4e2d\u5956", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    TASK_COMPLETED(15, "\u4efb\u52a1\u5b8c\u6210\uff08\u65e5\u5e38/\u65b0\u624b\uff09", MessageBehaviorEnum.UN_JUMP, Boolean.TRUE, MessageTypeEnum.SYSTEM),
    NEW_MERCHANT(16, "\u5546\u5bb6\u63d0\u4ea4\u4fe1\u606f\u6210\u529f", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    MERCHANT_VERIFY(18, "\u5546\u5bb6\u5ba1\u6838\u5931\u8d25", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    POST_REVIEW_PASS(54, "\u5e16\u5b50\u5ba1\u6838\u901a\u8fc7", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    ESSENCE_POST(55, "\u7cbe\u534e\u5e16\u901a\u77e5", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    IM_CHAT_ROOM_TIMING_RED_PACKET_MESSAGE(100, "\u7fa4\u804a\u5b9a\u65f6\u7ea2\u5305\u63d0\u9192", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.SYSTEM),
    INVITE(81, "\u9080\u8bf7\u901a\u77e5", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.INVITE),
    ADD_FUNS(98, "\u65b0\u589e\u7c89\u4e1d", MessageBehaviorEnum.JUMP, Boolean.TRUE, MessageTypeEnum.ADD_FUNS),
    POST(8, "\u5e16\u5b50", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.NEWS),
    INTERACTION_MSG(5, "\u4e92\u52a8\u6d88\u606f", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE, MessageTypeEnum.INTERACTION),
    POST_LIKE(53, "\u5e16\u5b50\u70b9\u8d5e", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.LIKE),
    BELONG_POST_LIKE(58, "\u5e16\u5b50\u6240\u5c5e\u4eba\u70b9\u8d5e", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.LIKE),
    POST_REPLY(52, "\u5e16\u5b50\u56de\u590d", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.COMMENT),
    BELONG_POST_REPLY(57, "\u5e16\u5b50\u6240\u5c5e\u4eba\u56de\u590d", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.COMMENT),
    AT(107, "@\u6211\u7684\u8bc4\u8bba", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.AT_ME),
    AT_SUB(108, "@\u6211\u7684\u4e8c\u7ea7\u8bc4\u8bba", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.AT_ME),
    FAIL_WITHDRAW(60, "\u60a8\u7684\u5fae\u4fe1\u53f7\u672a\u5b9e\u540d\u8ba4\u8bc1\uff0c\u63d0\u73b0\u5931\u8d25", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.BALANCE),
    ADD_CASH(61, "\u65b0\u589e\u8d4f\u91d1", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.BALANCE),
    SUCCESS_WITHDRAW(62, "\u60a8\u7684\u63d0\u73b0\u5df2\u6210\u529f\u6253\u6b3e", MessageBehaviorEnum.JUMP, Boolean.FALSE, MessageTypeEnum.BALANCE);

    private int type;
    private String desc;
    private MessageBehaviorEnum behavior;
    private Boolean silence;
    private MessageTypeEnum groupType;

    private PushMessageEnum(int type, String desc, MessageBehaviorEnum behavior, Boolean silence, MessageTypeEnum groupType) {
        this.type = type;
        this.desc = desc;
        this.behavior = behavior;
        this.silence = silence;
        this.groupType = groupType;
    }

    public MessageTypeEnum getGroupType() {
        return this.groupType;
    }

    public static String getMessageDescByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getDesc();
        }
        return null;
    }

    public static PushMessageEnum getMessageByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum;
        }
        return SYSTEM_MSG;
    }

    public static String getMessageDescByType(String type) {
        return PushMessageEnum.getMessageDescByType(NumberUtils.parseToInt((String)type));
    }

    public static MessageBehaviorEnum getMessageBehaviorByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getBehavior();
        }
        return null;
    }

    public static Boolean getMessageSilenceByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getSilence();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public MessageBehaviorEnum getBehavior() {
        return this.behavior;
    }

    public Boolean getSilence() {
        return this.silence;
    }
}

