package com.bxm.localnews.mq.common.model.dto;

import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;
import com.bxm.newidea.component.vo.BaseBean;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 要召回的数据
 *
 * @author pf.w
 * @date 2020/11/26 15:19
 **/
public class MessageFilterInfo extends BaseBean {

    /**
     * 逻辑ID 如：评论id  帖子id  。。。
     */
    private Long logicId;

    /**
     * 用户ID 可为空
     */
    private Long userId;

    /**
     * 目标用户ID 可为空
     */
    private Long targetUserId;

    /**
     * 类型
     */
    private MessageFilterEventTypeEnum eventTypeEnum;

    /**
     * 也加个额外参数
     */
    private Map<String, Object> extend = Maps.newHashMap();

    /**
     * 扩展字段 json
     */
    private String extDate;

    public MessageFilterInfo bulidFilterForReply(Long replyId, MessageFilterEventTypeEnum eventTypeEnum) {
        this.logicId = replyId;
        this.eventTypeEnum = eventTypeEnum;
        return this;
    }

    public MessageFilterInfo addExtend(String key, Object value) {
        if (this.extend == null) {
            this.extend = Maps.newHashMap();
        }

        this.extend.put(key, value);
        return this;
    }

    public Map<String, Object> getExtend() {
        return extend;
    }

    public void setExtend(Map<String, Object> extend) {
        this.extend = extend;
    }

    public Long getTargetUserId() {
        return targetUserId;
    }

    public void setTargetUserId(Long targetUserId) {
        this.targetUserId = targetUserId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getLogicId() {
        return logicId;
    }

    public void setLogicId(Long logicId) {
        this.logicId = logicId;
    }

    public MessageFilterEventTypeEnum getEventTypeEnum() {
        return eventTypeEnum;
    }

    public void setEventTypeEnum(MessageFilterEventTypeEnum eventTypeEnum) {
        this.eventTypeEnum = eventTypeEnum;
    }

    public String getExtDate() {
        return extDate;
    }

    public void setExtDate(String extDate) {
        this.extDate = extDate;
    }
}
