package com.bxm.egg.message.facade.service;

import com.bxm.egg.mq.common.model.dto.MessageFilterInfo;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.param.DingtalkMessage;

/**
 * APP应用消息推送，仅支持单条消息推送，不支持全量推送
 * 此服务面向的是其他服务
 *
 * @author liujia
 * @date 2020-07-03 15:58
 **/
public interface MessageFacadeService {

    /**
     * 推送消息给用户
     *
     * @param message 推送消息内容，不支持群推，仅支持单个用户推送
     */
    void sendPushMessage(PushMessage message);

    /**
     * 添加消息到用户消息中心，但是不会进行推送
     *
     * @param message 消息内容,消息内容中必须有用户ID
     */
    void sendUserMessage(PushMessage message);

    /**
     * 推送消息的召回处理
     * <p>
     * 说明 ：因对后续召回逻辑预判有限，目前该方法处理比较简陋，只处理了评论消息不可见后的删除逻辑
     * 如后续有相关逻辑，可在此基础上进行再开发
     *
     * @param info
     */
    void sendMsgFilterEvent(MessageFilterInfo info);

    /**
     * 发送钉钉消息
     *
     * @param message 钉钉消息内容
     */
    void sendDingtalk(DingtalkMessage message);
}
