package com.bxm.egg.message.facade.service;

import com.bxm.egg.mq.common.model.dto.SendSmsResult;
import com.bxm.egg.mq.common.model.dto.SmsSupplyDTO;

/**
 * 短消息集成服务
 *
 * @author liujia
 * @date 2020-07-15 22:31
 **/
public interface SmsFacadeService {

    /**
     * 判断验证码是否正确
     *
     * @param type    验证码类型,暂时是硬编码，需要进行重构处理
     * @param phoneNo 手机号码
     * @param code    用户输入的验证码
     * @return true 表示验证通过
     */
    Boolean verify(Byte type, String phoneNo, String code);

    /**
     * 自定义短信参数发送短信
     *
     * @param param 短信发送参数
     * @return 短信发送结果
     */
    SendSmsResult send(SmsSupplyDTO param);
}
