package com.bxm.egg.message.facade.service;

import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Date;

/**
 * @author liujia
 * @date 10/9/21 4:54 PM
 **/
@DubboService(protocol = "dubbo", version = "1.0.0")
@Slf4j
@AllArgsConstructor
public class IMFacadeServiceImpl implements IMFacadeService {

    private IMSDKAdapter imsdkAdapter;

    @Override
    public Message block(Long userId, Date endTime) {
        if (null == endTime) {
            return Message.build(false, "请设置禁言截止时间");
        }

        return imsdkAdapter.block(userId, (int) DateUtils.getDiffMinutes(new Date(), endTime, true));
    }

    @Override
    public Message unblock(Long userId) {
        return imsdkAdapter.unblock(userId);
    }

    @Override
    public void syncUserInfo(Long userId, String nickName, String headImg) {
        UserInfoBean userInfo = new UserInfoBean();
        userInfo.setId(userId);
        userInfo.setNickname(nickName);
        userInfo.setHeadImg(headImg);

        imsdkAdapter.update(userInfo);
    }
}
