package com.bxm.localnews.im.activity;

import com.bxm.localnews.im.dto.activity.RedPackageDto;
import com.bxm.localnews.im.dto.activity.RedPackageStatusDto;
import com.bxm.localnews.im.param.activity.RedPackageStatusParam;
import com.bxm.localnews.im.param.group.BaseGroupParam;

/**
 * 红包信息和红包领取相关接口
 *
 * @author liujia
 * @date 9/26/21 11:51 AM
 **/
public interface RedPacketDetailService {

    /**
     * 获取群内最近的一个红包
     * 获取下一个即将可以领取的红包
     *
     * @param param 群组参数
     * @return 红包信息
     */
    RedPackageDto getClosestRedpacket(BaseGroupParam param);

    /**
     * 获取红包的当前状态
     *
     * @param param 查询参数
     * @return 红包状态信息
     */
    RedPackageStatusDto getUserRedpacketStatus(RedPackageStatusParam param);

    /**
     * 获取红包的当前状态
     *
     * @param detailId 红包ID
     * @return 红包状态
     */
    RedPackageStatusDto getStatus(Long detailId);

    /**
     * 移除红包投放计划对应的红包信息
     *
     * @param planId 投放计划
     */
    void removePlanDetail(Long planId);

    /**
     * 根据投放计划创建一个红包详情
     * 如果存在未领取的可用状态红包，则继续沿用，不做处理
     * 如果不存在可领取的红包，则创建一个红包详情，并添加对应的提醒队列
     *
     * @param planId 投放计划ID
     */
    void createPlanDetail(Long planId);

    /**
     * 关闭一个红包详情
     *
     * @param redpacketDetailId 红包详情ID
     */
    void closePlanDetail(Long redpacketDetailId);

    /**
     * 将红包从等待开始变更为激活状态
     */
    void processStatusPlan();
}
