package com.bxm.localnews.im.activity;

import com.bxm.egg.message.param.manage.IdParam;
import com.bxm.localnews.im.dto.activity.ImTimingRedPacketPlanDTO;
import com.bxm.localnews.im.param.activity.ChangeRedPackageStatusParam;
import com.bxm.localnews.im.param.activity.CreateTimingRedPacketPlanParam;
import com.bxm.localnews.im.param.activity.UpdateTimingRedPacketPlanParam;
import com.bxm.newidea.component.bo.Message;

import java.util.List;

/**
 * 红包投放计划服务
 *
 * @author liujia
 * @date 9/26/21 9:22 AM
 **/
public interface RedPacketPlanService {

    /**
     * 根据群组ID获取红包
     *
     * @param groupId 群组ID
     * @return 投放计划
     */
    List<ImTimingRedPacketPlanDTO> getPlanListByGroupId(Long groupId);

    /**
     * 创建红包投放计划项
     *
     * @param param 创建参数
     * @return 创建结果，包含红包ID
     */
    Message createPlan(CreateTimingRedPacketPlanParam param);

    /**
     * 变更红包投放计划，不改变已经生成的红包信息
     *
     * @param param 变更参数
     * @return 变更结果
     */
    Message changePlan(UpdateTimingRedPacketPlanParam param);

    /**
     * 删除红包投放计划
     * 如果红包投放计划存在进行中的红包信息，则关闭
     *
     * @param param 投放计划ID
     * @return 移除结果
     */
    Message remove(IdParam param);

    /**
     * 变更红包投放计划的状态
     * 如果红包投放计划存在进行中的红包信息，则关闭
     *
     * @param param 变更参数
     * @return 处理结果
     */
    Message changeStatus(ChangeRedPackageStatusParam param);

    /**
     * 处理红包计划，将红包计划转化为具体的可领取红包
     * 主要是用于补充，防止各种奇奇怪怪的状态变更导致红包没有正常开启
     * 用于做数据补救
     */
    void processPlan();
}
