package com.bxm.localnews.im.activity;

import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.param.activity.RedPackageRemindParam;
import com.bxm.newidea.component.bo.Message;

/**
 * 红包提醒，包括红包的自动提醒和用户提醒
 *
 * @author liujia
 * @date 9/26/21 11:40 AM
 **/
public interface RedPacketReminderService {

    /**
     * 添加或移除一个用户领取红包的提醒
     * 用户添加提醒后就一直提醒，直到手动取消，和红包没关系
     *
     * @param param 参数
     * @return 处理结果
     */
    Message addOrRemoveRemind(RedPackageRemindParam param);

    /**
     * 用户是否开启了提醒
     *
     * @param userId  用户ID
     * @param groupId 群组ID
     */
    boolean enableRemind(Long userId, Long groupId);

    /**
     * 处理红包提醒信息，发送红包的相关提醒信息到群聊中
     */
    void processRemind();

    /**
     * 红包开启前5分钟，给开启了提醒的用户推送消息
     */
    void processUserRemind();

    /**
     * 给红包添加系统提醒，供定时任务扫描后进行触发
     *
     * @param detail 红包详情
     */
    void addRedpacketRemind(RedpacketPlanDetailEntity detail);

    /**
     * 删除红包的系统提醒
     *
     * @param detailId 红包ID
     */
    void removeRedpacketRemind(Long detailId);
}
