package com.bxm.localnews.im.activity;

import com.bxm.localnews.im.dto.activity.RedPackageDetailDto;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.param.activity.OpenRedPackageParam;
import com.bxm.localnews.im.param.activity.RedPackageDetailParam;

/**
 * 红包领取相关的逻辑
 *
 * @author liujia
 * @date 9/26/21 4:12 PM
 **/
public interface RedpacketReceiveService {

    /**
     * 开红包，用户从领取的红包中获取一个，不管获取是否成功，均返回红包状态
     *
     * @param param 开启红包的参数
     * @return 红包详情
     */
    RedPackageDetailDto executeOpen(OpenRedPackageParam param);

    /**
     * 获取红包详情
     *
     * @param param 请求红包参数
     * @return 红包详情
     */
    RedPackageDetailDto getDetail(RedPackageDetailParam param);

    /**
     * 创建红包的领取队列，红包创建时
     *
     * @param detailEntity 红包详情
     */
    void createReceiveQueue(RedpacketPlanDetailEntity detailEntity);

    /**
     * 移除红包的领取队列
     *
     * @param detailId 红包ID
     */
    void removeReceiveQueue(Long detailId);

    /**
     * 用户是否已经领取过该红包
     *
     * @param detailId 红包ID
     * @param userId   用户ID
     * @return 是否领取过
     */
    boolean isReceived(Long detailId, Long userId);
}
