package com.bxm.localnews.im.activity.impl;

import com.bxm.egg.message.param.manage.IdParam;
import com.bxm.egg.message.utils.AdminUtils;
import com.bxm.localnews.im.activity.RedPacketDetailService;
import com.bxm.localnews.im.activity.RedPacketPlanService;
import com.bxm.localnews.im.domain.activity.RedpacketPlanMapper;
import com.bxm.localnews.im.dto.activity.ImTimingRedPacketPlanDTO;
import com.bxm.localnews.im.entity.activity.RedpacketPlanEntity;
import com.bxm.localnews.im.enums.RedPacketTypeEnum;
import com.bxm.localnews.im.param.activity.ChangeRedPackageStatusParam;
import com.bxm.localnews.im.param.activity.CreateTimingRedPacketPlanParam;
import com.bxm.localnews.im.param.activity.UpdateTimingRedPacketPlanParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author liujia
 * @date 9/26/21 1:52 PM
 **/
@Slf4j
@Service
@AllArgsConstructor
public class RedPacketPlanServiceImpl implements RedPacketPlanService {

    private RedpacketPlanMapper redpacketPlanMapper;

    private RedPacketDetailService redPacketDetailService;

    @Override
    public List<ImTimingRedPacketPlanDTO> getPlanListByGroupId(Long groupId) {
        List<ImTimingRedPacketPlanDTO> planDTOList = redpacketPlanMapper.getPlanListByGroupId(groupId);
        for (ImTimingRedPacketPlanDTO packetPlanDTO : planDTOList) {
            packetPlanDTO.setEveryDay(-1 == packetPlanDTO.getMaxTimes());
        }
        return planDTOList;
    }

    @Override
    public Message createPlan(CreateTimingRedPacketPlanParam param) {
        RedpacketPlanEntity entity = new RedpacketPlanEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setCreateTime(new Date());
        entity.setCurrentTimes(0);
        entity.setEnable(1);
        if (Boolean.TRUE.equals(param.getEveryDay())) {
            entity.setMaxTimes(-1);
        } else {
            entity.setMaxTimes(1);
        }
        entity.setType(RedPacketTypeEnum.GROUP.getType());

        entity.setHour(param.getSendHour());
        entity.setMinute(param.getSendMinute());
        entity.setMinNum(param.getMinGrainNum());
        entity.setMaxNum(param.getMaxGrainNum());
        entity.setTotalGrain(param.getTotalGrainNum());
        entity.setRelationId(param.getGroupId());
        entity.setOperator(AdminUtils.getAdminUserId());

        Message message = check(entity);
        if (!message.isSuccess()) {
            return message;
        }

        int result = redpacketPlanMapper.insert(entity);
        return Message.build(result);
    }

    @Override
    public Message changePlan(UpdateTimingRedPacketPlanParam param) {
        RedpacketPlanEntity entity = new RedpacketPlanEntity();
        entity.setId(param.getRecordId());
        entity.setHour(param.getSendHour());
        entity.setMinute(param.getSendMinute());
        entity.setTotalGrain(param.getTotalGrainNum());
        entity.setMinNum(param.getMinGrainNum());
        entity.setMaxNum(param.getMaxGrainNum());
        if (Boolean.TRUE.equals(param.getEveryDay())) {
            entity.setMaxTimes(-1);
        } else {
            entity.setMaxTimes(1);
        }

        Message message = check(entity);
        if (!message.isSuccess()) {
            return message;
        }

        redPacketDetailService.removePlanDetail(entity.getId());

        return Message.build(redpacketPlanMapper.updateById(entity));
    }

    private Message check(RedpacketPlanEntity entity) {
        if (entity.getMinNum() > entity.getMaxNum()) {
            return Message.build(false, "可领取数量最小值不能大于最大值");
        }

        return Message.build();
    }

    @Override
    public Message remove(IdParam param) {
        // 删除正在进行中的红包
        redPacketDetailService.removePlanDetail(param.getId());
        return Message.build(redpacketPlanMapper.remove(param.getId()));
    }

    @Override
    public Message changeStatus(ChangeRedPackageStatusParam param) {
        // 如果是禁用，则关闭正在领取状态的红包
        if (Objects.equals(0, param.getStatus())) {
            redPacketDetailService.removePlanDetail(param.getId());
        }

        return Message.build(redpacketPlanMapper.changeStatus(param));
    }

    @Override
    public void processPlan() {
        // 查询近一个半小时内要开启的红包计划，创建对应的红包信息
        LocalDateTime nowTime = LocalDateTime.now(ZoneId.systemDefault());

        LocalDateTime maxTime = LocalDateTime.now(ZoneId.systemDefault());
        maxTime = maxTime.plusHours(2);

        Date today = DateUtils.clearTimePart(new Date());

        List<RedpacketPlanEntity> activePlanList = redpacketPlanMapper.queryActivePlanByTime(
                nowTime.getHour(),
                maxTime.getHour(),
                today);

        for (RedpacketPlanEntity planEntity : activePlanList) {
            redPacketDetailService.createPlanDetail(planEntity.getId());
        }
    }
}

























