package com.bxm.localnews.im.activity.impl;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.im.activity.RedPacketReminderService;
import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.domain.activity.RedpacketPlanDetailMapper;
import com.bxm.localnews.im.domain.activity.RedpacketRemindMapper;
import com.bxm.localnews.im.domain.activity.RedpacketRemindMessageMapper;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.entity.activity.RedpacketRemindEntity;
import com.bxm.localnews.im.entity.activity.RedpacketRemindMessageEntity;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.enums.GroupStatusEnum;
import com.bxm.localnews.im.group.GroupService;
import com.bxm.localnews.im.param.activity.RedPackageRemindParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.thirdpart.message.TextMessage;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

import static com.bxm.localnews.im.constant.RedPacketRedisConstant.REDPACKET_REMIND_LOCK;
import static com.bxm.localnews.im.constant.RedPacketRedisConstant.REDPACKET_USER_REMIND_LOCK;

/**
 * @author liujia
 * @date 9/26/21 1:52 PM
 **/
@Service
@Slf4j
@AllArgsConstructor
public class RedPacketReminderServiceImpl implements RedPacketReminderService {

    private RedpacketRemindMapper redpacketRemindMapper;

    private RedpacketRemindMessageMapper redpacketRemindMessageMapper;

    private IMSDKAdapter imsdkAdapter;

    private DistributedLock distributedLock;

    private RedPacketProperties redPacketProperties;

    private RedpacketPlanDetailMapper redpacketPlanDetailMapper;

    private GroupService groupService;

    private MessageFacadeService messageFacadeService;

    @Override
    public Message addOrRemoveRemind(RedPackageRemindParam param) {
        if (param.getSwitchVal()) {
            RedpacketRemindEntity remindEntity = redpacketRemindMapper.selectByUserId(param.getUserId(), param.getGroupId());

            if (remindEntity == null) {
                RedpacketRemindEntity saveEntity = new RedpacketRemindEntity();
                saveEntity.setId(SequenceHolder.nextLongId());
                saveEntity.setUserId(param.getUserId());
                saveEntity.setGroupId(param.getGroupId());
                saveEntity.setCreateTime(new Date());

                redpacketRemindMapper.insert(saveEntity);
            }
        } else {
            redpacketRemindMapper.deleteByUserId(param.getUserId(), param.getGroupId());
        }

        return Message.build();
    }

    @Override
    public boolean enableRemind(Long userId, Long groupId) {
        return redpacketRemindMapper.selectByUserId(userId, groupId) != null;
    }

    @Override
    public void processRemind() {
        String lockKey = REDPACKET_REMIND_LOCK.gen();
        if (distributedLock.lock(lockKey)) {
            Date sendTime = DateUtils.addField(new Date(), Calendar.MINUTE, 1);
            List<RedpacketRemindMessageEntity> unsentRemindList = redpacketRemindMessageMapper.queryRemind(sendTime);

            if (unsentRemindList.size() > 0) {
                for (RedpacketRemindMessageEntity remindMessageEntity : unsentRemindList) {
                    imsdkAdapter.sendGroupMessage(remindMessageEntity.getRelationId(),
                            redPacketProperties.getChatRoomTimingRedPacketAssistantUserId(),
                            TextMessage.builder().content(remindMessageEntity.getContent()).build());
                }

                redpacketRemindMessageMapper.removeSendRemind(sendTime);
            }

            distributedLock.unlock(lockKey);
        } else {
            log.info("其他实例已经处理了红包的系统消息提醒");
        }
    }

    @Override
    public void processUserRemind() {
        String lockKey = REDPACKET_USER_REMIND_LOCK.gen();
        if (distributedLock.lock(lockKey, 1, TimeUnit.MINUTES)) {
            // 查询五分钟之内可以领取的红包
            Date receiveDate = DateUtils.addField(new Date(), Calendar.MINUTE, 5);

            List<RedpacketPlanDetailEntity> waitRedpacketList = redpacketPlanDetailMapper.getWaitRedpacket(receiveDate);

            if (waitRedpacketList.size() > 0) {
                for (RedpacketPlanDetailEntity detailEntity : waitRedpacketList) {
                    // 判断群聊是否开启
                    ImGroupEntity groupEntity = groupService.getGroupEntity(detailEntity.getRelationId());
                    if (GroupStatusEnum.DISABLE.match(groupEntity.getStatus())) {
                        log.info("群组[{}]已被禁用，不需要发送提醒信息", detailEntity.getRelationId());
                        continue;
                    }

                    sendAllRemind(detailEntity);
                }
            }
        } else {
            log.info("其他实例正在执行用户红包提醒");
        }
    }

    private void sendAllRemind(RedpacketPlanDetailEntity detailEntity) {
        List<Long> userIdList = redpacketRemindMapper.selectRemindUserByGroupId(detailEntity.getRelationId());
        //  发送推送
        String protocol = ProtocolFactory.groupChat().app().groupId(detailEntity.getRelationId()).build();
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.IM_CHAT_ROOM_TIMING_RED_PACKET_MESSAGE);
        info.setMsgId(SequenceHolder.nextLongId());
        // 设置跳转路由
        info.addExtend("url", protocol);
        // 聊天室id
        info.addExtend("chatRoomId", detailEntity.getRelationId());
        // 跳转协议
        info.setProtocol(protocol);

        String content = detailEntity.getTotalGrain() + "g粮食礼包还有3分钟就要开抢了，赶快进群准备吧~";
        PushMessage message = PushMessage.build();
        message.setTitle("粮食礼包马上开抢");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushGroup(userIdList));
        message.setPayloadInfo(info);

        messageFacadeService.sendPushMessage(message);
    }

    @Override
    public void addRedpacketRemind(RedpacketPlanDetailEntity detail) {
        // 红包发放前120分钟
        RedpacketRemindMessageEntity entity = new RedpacketRemindMessageEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setDetailId(detail.getId());
        entity.setSendFlag(0);
        entity.setRelationId(detail.getRelationId());
        entity.setSendTime(DateUtils.addField(detail.getReceiveTime(), Calendar.SECOND, -120));
        entity.setContent("定时红包还有120秒到达，准备好开抢了吗");
        redpacketRemindMessageMapper.insert(entity);

        // 红包发放前60秒
        entity = new RedpacketRemindMessageEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setDetailId(detail.getId());
        entity.setSendFlag(0);
        entity.setRelationId(detail.getRelationId());
        entity.setSendTime(DateUtils.addField(detail.getReceiveTime(), Calendar.SECOND, -60));
        entity.setContent("定时红包还有60秒到达，准备好开抢了吗");

        redpacketRemindMessageMapper.insert(entity);

    }

    @Override
    public void removeRedpacketRemind(Long detailId) {
        redpacketRemindMessageMapper.deleteByDetailId(detailId);
    }
}
