package com.bxm.localnews.im.activity.strategy;

import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.enums.RedpacketQueueStrategyEnum;
import com.bxm.newidea.component.annotations.StrategyBean;
import com.bxm.newidea.component.strategy.IReturnedStrategy;
import com.bxm.newidea.component.tools.RandomUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import static com.bxm.localnews.im.constant.LogicGroupConstant.RAD_PACKET_QUEUE;

/**
 * 根据发放的总数量、最大值、最小值，生成一个随机的领取队列，尽量的随机
 * 除非出现特殊的无法满足的情况，否决尽量符合最大、最小值的限定
 *
 * @author liujia
 * @date 9/26/21 5:19 PM
 **/
@StrategyBean(group = RAD_PACKET_QUEUE)
@Slf4j
public class RandomStrategy implements IReturnedStrategy<List<Integer>, RedpacketQueueContext> {
    @Override
    public List<Integer> execute(RedpacketQueueContext redpacketQueueContext) {
        RedpacketPlanDetailEntity detailEntity = redpacketQueueContext.getDetailEntity();
        return createRandomQueue(detailEntity.getTotalGrain(), detailEntity.getMinNum(), detailEntity.getMaxNum());
    }

    @Override
    public boolean match(RedpacketQueueContext param) {
        return RedpacketQueueStrategyEnum.RANDOM.equals(param.getStrategy());
    }

    @SuppressWarnings("AlibabaMethodTooLong")
    private List<Integer> createRandomQueue(int total, int min, int max) {
        // 中间值
        int mid = (min + max) / 2;
        // 预期有多少个
        int num = (total / mid);

        // 只能创建一个随机数的情况，直接返回
        if (num == 1) {
            log.warn("总数只够创建一个随机值，返回总数。总数为：{},最大值：{},最小值：{}",
                    total,
                    min,
                    max);
            return Lists.newArrayList(total);
        }

        List<Integer> result = Lists.newArrayList();

        int last = total;

        // 进行随机分片
        for (int i = 0; i < (num / 2); i++) {
            int scope = max - mid;
            if (max - mid > min) {
                scope = (max - mid) / 3;
            }
            int random = RandomUtils.nextInt(0, scope);

            result.add(mid + random);
            result.add(mid - random);

            last -= mid * 2;
        }

        // 对余数进行处理
        if (last != 0) {
            int lastNum = last / mid;

            if (lastNum > 0) {
                for (int i = 0; i < lastNum; i++) {
                    result.add(mid);
                    last -= mid;
                }
            }

            int fillNum = result.stream().mapToInt(item -> max - item).sum();
            int extractNum = result.stream().mapToInt(item -> item - min).sum();

            if (last <= fillNum) {
                // 将余数填充到未满的数据中
                while (last > 0) {
                    for (int i = 0; i < result.size(); i++) {
                        if (last > 0) {
                            if (result.get(i) < max) {
                                result.set(i, result.get(i) + 1);
                                last--;
                            }
                        }
                    }
                }
            } else if (extractNum + last >= min) {
                // 将余数进行抽取，组成一个新的项目
                int finalItem = last;
                while (last > 0) {
                    for (int i = 0; i < result.size(); i++) {
                        if (finalItem >= min) {
                            last = 0;
                            break;
                        }
                        if (last > 0) {
                            if (result.get(i) < max && result.get(i) > min) {
                                result.set(i, result.get(i) - 1);
                                last--;
                                finalItem++;
                            }
                        }
                    }
                }

                result.add(finalItem);
            } else {
                log.warn("出现无法满足限定条件的情况，总数：{}，最小值:{}，最大值：{},剩余值：{}",
                        total,
                        min,
                        max,
                        last);
                result.add(last);
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("total:{},min:{},max:{},result:{}",
                    total,
                    min,
                    max,
                    result);
        }

        return result;
    }
}
