package com.bxm.localnews.im.chat;


import com.bxm.localnews.im.dto.chat.ChatMessageDTO;
import com.bxm.localnews.im.dto.group.GroupMessageDTO;
import com.bxm.localnews.im.entity.HistoryChatBean;
import com.bxm.localnews.im.param.chat.GroupMessageQueryParam;
import com.bxm.localnews.im.param.chat.ImHistoryParam;
import com.bxm.localnews.im.param.chat.ImMessageQueryParam;
import com.bxm.newidea.component.dto.IPageModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 即时通讯相关服务
 *
 * @author liujia
 */
public interface IMManageService {
    /**
     * 查询聊天记录
     *
     * @param param 查询参数
     * @return 聊天记录列表
     */
    List<ChatMessageDTO> query(ImMessageQueryParam param);

    /**
     * 查询群组聊天记录
     *
     * @param param 查询条件
     * @return 群组消息列表
     */
    IPageModel<GroupMessageDTO> queryGroupMessage(GroupMessageQueryParam param);

    /**
     * 查询用户的历史聊天记录
     *
     * @param param param
     * @return 历史聊天对象
     */
    List<HistoryChatBean> queryHistory(ImHistoryParam param);

    void getVoiceByContent(String content, HttpServletResponse response);


    /**
     * 清除马甲号与真实用户聊天记录的未回复数量
     *
     * @param virtualUserId
     * @param realUserId
     * @return
     */
    Boolean clearChatRecord(Long virtualUserId, Long realUserId);
}
