package com.bxm.localnews.im.chat;

import com.bxm.localnews.im.param.chat.GiftParam;
import com.bxm.newidea.component.bo.Message;

/**
 * 即时通讯服务
 *
 * @author liujia
 */
public interface IMService {

    /**
     * 获取融云通讯SDK
     * 根据用户ID从缓存中获取token，如果不存在则调用SDK获取
     *
     * @param userId 客户端用户ID
     * @return 客户端通讯SDK, 如果创建失败将返回空字符串
     */
    String getToken(Long userId);

    /**
     * 统计今日用户的消息发送情况
     */
    void countAndPush();


    /**
     * 用户昵称、头像变更时触发，更新远程的
     *
     * @param userId 信息变更的用户
     */
    void updateUser(Long userId);

    /**
     * 执行好友的赠送粮食的逻辑
     * 用户之间增送粮食的数量是固定的
     * 需要校验赠送方是否足够
     * 每日好友之间可以赠送一次
     *
     * @param param 赠送粮食的参数
     * @return 处理结果
     */
    Message executeGift(GiftParam param);
}
