package com.bxm.localnews.im.chat.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.message.dto.LocationDTO;
import com.bxm.egg.message.integration.LocationIntegrationService;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.chat.IMManageService;
import com.bxm.localnews.im.domain.IMMapper;
import com.bxm.localnews.im.dto.chat.ChatMessageDTO;
import com.bxm.localnews.im.dto.group.GroupMessageDTO;
import com.bxm.localnews.im.entity.HistoryChatBean;
import com.bxm.localnews.im.param.chat.GroupMessageQueryParam;
import com.bxm.localnews.im.param.chat.ImHistoryParam;
import com.bxm.localnews.im.param.chat.ImMessageQueryParam;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.bxm.localnews.im.constant.ImRedisKey.VIRTURE_USER_UNREPLY;

@Service
@AllArgsConstructor
@Slf4j
public class IMManageServiceImpl implements IMManageService {

    private final IMMapper imMapper;

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final UserIntegrationService userIntegrationService;

    private final LocationIntegrationService locationIntegrationService;

    @Override
    public List<ChatMessageDTO> query(ImMessageQueryParam param) {
        Preconditions.checkArgument(param != null);

        List<ChatMessageDTO> result = Lists.newArrayList();

        if (null != param.getSender() && null != param.getReceiver()) {
            result.addAll(imMapper.query(param));

            long sender = param.getSender();
            param.setSender(param.getReceiver());
            param.setReceiver(sender);
            result.addAll(imMapper.query(param));

            result = result.stream().sorted(Comparator.comparing(ChatMessageDTO::getSendTime)).collect(Collectors.toList());
        } else {
            result = imMapper.query(param);
        }

        Set<Long> userIdSet = Sets.newHashSet();
        for (ChatMessageDTO messageBean : result) {
            userIdSet.add(messageBean.getSender());
            userIdSet.add(messageBean.getReceiver());
        }

        Map<Long, UserInfoBean> userInfoBeanMap = userIntegrationService.queryUserList(userIdSet);

        for (ChatMessageDTO messageBean : result) {
            UserInfoBean userInfoBean = userInfoBeanMap.get(messageBean.getReceiver());
            if (null != userInfoBean) {
                messageBean.setReceiverName(userInfoBean.getNickname());
            }

            userInfoBean = userInfoBeanMap.get(messageBean.getSender());
            if (null != userInfoBean) {
                messageBean.setSenderName(userInfoBean.getNickname());
            }
        }

        //如果是语音设置语音的时长
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(e -> {
                if (StringUtils.equals("RC:VcMsg", e.getObjectName())) {
                    e.setDuration(getDurationByContent(e.getPrimitiveContent()));
                }
            });
        }


        return result;
    }

    @Override
    public IPageModel<GroupMessageDTO> queryGroupMessage(GroupMessageQueryParam param) {
        Page<GroupMessageDTO> page = new Page<>(param.getPageNum(), param.getPageSize());
        PlusPageModelDTO<GroupMessageDTO> pageModel = PlusPageModelDTO.build(imMapper.queryGroupMessage(page, param));

        for (GroupMessageDTO chatMessageDTO : pageModel.getList()) {
            UserInfoBean userInfo = userIntegrationService.getUserInfo(chatMessageDTO.getSender());
            if (null != userInfo) {
                chatMessageDTO.setSenderName(userInfo.getNickname());
            }

            LocationDTO locationDTO = locationIntegrationService.getLocationByGeocode(chatMessageDTO.getAreaCode());
            chatMessageDTO.setAreaName(locationDTO.getName());
        }

        return pageModel;
    }

    private int getDurationByContent(String content) {
        JSONObject result = JSONObject.parseObject(content);
        return result.getInteger("duration");
    }


    @Override
    public List<HistoryChatBean> queryHistory(ImHistoryParam param) {
        List<Long> userIdList = imMapper.queryHistory(param);

        Map<Long, UserInfoBean> userInfoBeanMap = userIntegrationService.queryUserList(userIdList);

        List<HistoryChatBean> result = Lists.newArrayList();

        for (Long userId : userIdList) {
            UserInfoBean userInfo = userInfoBeanMap.get(userId);
            if (null != userInfo) {
                result.add(convert(userInfo));
            }
        }

        return result;
    }

    private HistoryChatBean convert(UserInfoBean userInfo) {
        HistoryChatBean history = new HistoryChatBean();
        history.setUserId(userInfo.getId());
        history.setHeadImg(userInfo.getHeadImg());
        history.setNickName(userInfo.getNickname());
        return history;
    }

    @Override
    public void getVoiceByContent(String id, HttpServletResponse response) {

        response.setCharacterEncoding("utf-8");
        response.setContentType("multipart/form-data");
        response.setHeader("Content-Disposition", "attachment;fileName=" + id + ".amr");
        String content = imMapper.selectContentById(id);
        try (OutputStream out = response.getOutputStream()) {
            byte[] audioByte = Base64.decode(content);
            out.write(audioByte);
            out.flush();
        } catch (Exception e) {
            log.error("下载文件错误", e);
        }

    }

    @Override
    public Boolean clearChatRecord(Long virtualUserId, Long realUserId) {
        KeyGenerator unReplyNumKey = VIRTURE_USER_UNREPLY.copy().appendKey(virtualUserId);
        Long remove = redisHashMapAdapter.remove(unReplyNumKey, String.valueOf(realUserId));
        return remove > 0;
    }

}
