package com.bxm.localnews.im.config;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@ConfigurationProperties(prefix = "chatroom.record")
@Component
@Data
public class ChatRoomRecordProperties {
    /**
     * 未开启红包的聊天文案
     */
    private List<String> chatRecord;

    /**
     * 开启红包的聊天文案
     */
    private String redpacketRecord;

    /**
     * 回复群组打招呼黑名单
     */
    private List<String> sayHelloBlankList = Lists.newArrayList();

}
