package com.bxm.localnews.im.config;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 即时通讯相关配置
 *
 * @author liujia
 */
@ConfigurationProperties(prefix = "im")
@Component
@Data
public class IMProperties {

    /**
     * 融云Appkey
     */
    private String rongcloudAppKey;

    /**
     * 融云AppSecret
     */
    private String rongcloudAppSecret;

    /**
     * 触发定时推送的时间点
     */
    private int triggerHour = 22;

    /**
     * 触发监控的用户数量
     */
    private int monitorNum = 10;

    /**
     * 客服号ID，用于发送新人引导
     */
    private Long customerServiceId;

    /**
     * 新人注册的欢迎信息
     */
    private String welcomeMsg = "欢迎！";

    /**
     * 新人注册的新人引导帖
     */
    private String welcomePost = "欢迎新人帖";

    /**
     * 引导完善资料阈值
     */
    private Integer nativeNewbieGuideThreshold = 80;

    /**
     * 不做限制的白名单用户ID
     */
    private List<Long> whiteList = Lists.newArrayList();

    /**
     * 群聊面包块背景图片
     */
    private String crumbImgUrl = "https://mtest.wstong.com/localnews_test/png/20201012/H8UKWHWUXWQJNYXZ24PELAPYBYWT3A6TP36GKE.png";

    /**
     * 好友之间赠送粮食的数量
     */
    private Integer reduceGiftGrain = 10;
}
