package com.bxm.localnews.im.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author Gonzo
 * @date 2019-10-30 14:17
 */
@ConfigurationProperties(prefix = "im.red-packet")
@Component
@Data
public class RedPacketProperties {

    /**
     * 红包领取计划的失效时间 单位s
     * 默认 1 天
     */
    private long distributePlanExpireTime = 60 * 60 * 24;

    /**
     * 红包已领完缓存失效时间 单位s
     * 默认 1 天
     */
    private long redPacketFinishedCacheTime = 60 * 60 * 24;

    /**
     * 缓存红包状态信息（红包状态页面）失效时间 单位s
     * 默认 1 天
     */
    private long redPacketStatusCacheTime = 60 * 60 * 24;

    /**
     * 缓存红包详细信息（红包详情页面）失效时间 单位s
     * 默认 1 天
     */
    private long redPacketDetailCacheTime = 60 * 60 * 24;

    /**
     * 红包小助手用户id
     */
    private Long chatRoomTimingRedPacketAssistantUserId = 1L;

    /**
     * 红包寄语
     */
    private String chatRoomTimingRedPacketRemark = "恭喜发财，大吉大利";

    /**
     * 红包发送人对应的头像地址（默认为蛋蛋佳的logo）
     */
    private String defaultRedpacketHeadImg = "";

    private String defaultRedpacketTitle = "定时粮食礼包";
}
