package com.bxm.localnews.im.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * @author gonzo
 * @date 2021-03-05 10:50
 **/
public class ImRedisKey {

    public static KeyGenerator BASE_KEY = DefaultKeyGenerator.build("im", "cache");


    /**
     * 私聊推送锁的key
     */
    public static KeyGenerator PRIVATE_PUSH_LOCK = BASE_KEY.copy().appendKey("privatePushLock");

    /**
     * 用户即时通讯token值
     */
    public static KeyGenerator TOKEN = DefaultKeyGenerator.build("im", "cache", "token");

    /**
     * 消息存储集合，防止消息丢失，控制消费速度
     */
    public static KeyGenerator MSG_SET = DefaultKeyGenerator.build("im", "cache", "consumemsg");

    /**
     * 用户的未读消息数量，此值在localnews-msg服务中维护，此处仅用于判断用户发送消息的权限
     */
    public static KeyGenerator UN_READ_MSG = DefaultKeyGenerator.build("message", "unread");

    /**
     * 2.5.1 用户各种类型的最后一条未读消息
     * 此值在localnews-msg服务中维护
     */
    public static KeyGenerator LAST_MSG = DefaultKeyGenerator.build("message", "last");

    /**
     * 用户聊天阅读过的小纸条
     */
    public static KeyGenerator USER_READ_NOTE = DefaultKeyGenerator.build("im", "note", "read");


    /**
     * 马甲号用户未回复数量
     */
    public static KeyGenerator VIRTURE_USER_UNREPLY = DefaultKeyGenerator.build("message", "virtureUser", "unReplyNum");

    /**
     * 马甲号用户未回复数量
     */
    public static KeyGenerator CHATROOM_RECENT_RECORD = DefaultKeyGenerator.build("im", "chatroom", "recentRecord");

    /**
     * 聊天屏蔽缓存
     */
    public static KeyGenerator IM_BLOCK_LIST = DefaultKeyGenerator.build("im", "block_list");

    /**
     * 该用户在聊天时是否提示过 <引导资料提示> 如：完善 个人资料，让双方相互之间更多了解
     */
    public static KeyGenerator SHOW_INFO_COMPLETE_GUIDE_FLAG = BASE_KEY.copy().appendKey("showInfoCompleteGuideFlag");

    /**
     * 用户之间相关赠送粮食的记录
     */
    public static KeyGenerator GIFT_RECORD_KEY = BASE_KEY.copy().appendKey("gift");

    /**
     * 群组实时信息缓存
     */
    public static KeyGenerator GROUP_RUNTIME_CACHE_KEY = DefaultKeyGenerator.build("im", "group", "runtime");
}
