package com.bxm.localnews.im.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * 红包相关的缓存键值
 *
 * @author Gonzo
 * @date 2019-10-29 19:44
 */

public class RedPacketRedisConstant {

    private static KeyGenerator BASE_KEY = DefaultKeyGenerator.build("redpacket", "cache");

    /**
     * 红包详情缓存
     */
    public static KeyGenerator REDPACKET_DETAIL_KEY = BASE_KEY.copy().appendKey("detail");

    /**
     * 红包可领取队列
     */
    public static KeyGenerator REDPACKET_RECEIVE_QUEUE_KEY = BASE_KEY.copy().appendKey("queue");

    /**
     * 领取了红包的用户
     */
    public static KeyGenerator REDPACKET_RECEIVE_CACHE_KEY = BASE_KEY.copy().appendKey("receive_user");

    /**
     * 每一个红包可领取的数量
     */
    public static KeyGenerator REDPACKET_RECEIVE_QUEUE_NUM_KEY = BASE_KEY.copy().appendKey("queue").appendKey("num");

    /**
     * 领取红包的分布式锁
     */
    public static KeyGenerator REDPACKET_OPEN_LOCK = BASE_KEY.copy().appendKey("open").appendKey("lock");

    /**
     * 红包提醒去抢的锁
     */
    public static KeyGenerator REDPACKET_REMIND_LOCK = BASE_KEY.copy().appendKey("remind").appendKey("lock");

    /**
     * 红包发放前给订阅了提醒的用户发送消息
     */
    public static KeyGenerator REDPACKET_USER_REMIND_LOCK = BASE_KEY.copy().appendKey("user").appendKey("remind").appendKey("lock");
}
