package com.bxm.localnews.im.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @author gonzo
 * @date 2021-03-05 11:39
 **/
public enum ChatBatchPushScopeEnum {

    // 0: 全部; 1: 用户级别推送; 2: 区域推送; 3: 用户行为推送
    NONE((byte) -1),
    /**
     * 融云限制 暂不支持
     */
    ALL((byte) 0),

    USER_IDS((byte) 1),

    /**
     * 融云限制 暂不支持
     */
    @Deprecated
    AREAS((byte) 2),


    ACTION_VIEW_POST((byte) 3),
    ;

    /**
     * 推送范围
     */
    private byte pushScope;

    ChatBatchPushScopeEnum(byte pushScope) {
        this.pushScope = pushScope;
    }

    public byte getPushScope() {
        return pushScope;
    }

    public static ChatBatchPushScopeEnum getByPushScopeType(Byte pushScopeType) {
        Optional<ChatBatchPushScopeEnum> any = Arrays.stream(ChatBatchPushScopeEnum.values())
                .filter(p -> Objects.equals(p.pushScope, pushScopeType))
                .findAny();

        return any.orElse(NONE);
    }
}
