package com.bxm.localnews.im.enums;

/**
 * 群组操作动作类型
 */
public enum ChatRoomOperationEnum {

    /**
     * 一段时间内禁言
     */
    BLOCK_PHASE(0),

    /**
     * 永久禁言
     */
    BLOCK_PERMANENT(1),

    /**
     * 解除禁言
     */
    UNBLOCK(2),

    /**
     * 群组消息撤回
     */
    RECALL(3),

    /**
     * 管理后台禁言
     */
    ADMIN_BLOCK(4),

    /**
     * 管理后台解除禁言
     */
    ADMIN_UNBLOCK(5),

    /**
     * 私聊消息撤回
     */
    PERSON_RECALL(6);

    private int code;

    public int getCode() {
        return code;
    }

    ChatRoomOperationEnum(int code) {
        this.code = code;
    }
}
