package com.bxm.localnews.im.enums;

import java.util.Objects;

/**
 * 群组操作
 *
 * @author liujia
 * @date 9/18/21 10:34 AM
 **/
public enum GroupActionEnum {

    /**
     * 屏蔽用户
     */
    BLOCK(1),

    /**
     * 解除屏蔽
     */
    UNBLOCK(2),

    /**
     * 提出群聊
     */
    KICK_OUT(3),

    /**
     * 创建
     */
    CREATE(4),

    /**
     * 变更
     */
    MODIFY(5);

    public static GroupActionEnum getByCode(int code) {
        for (GroupActionEnum actionEnum : GroupActionEnum.values()) {
            if (Objects.equals(actionEnum.getCode(), code)) {
                return actionEnum;
            }
        }

        return null;
    }

    private int code;

    public int getCode() {
        return code;
    }

    GroupActionEnum(int code) {
        this.code = code;
    }
}
