package com.bxm.localnews.im.enums;

import java.util.Objects;

/**
 * 群组状态
 *
 * @author liujia
 * @date 9/17/21 4:27 PM
 **/
public enum GroupStatusEnum {

    /**
     * 群已被禁用
     */
    DISABLE(0),

    /**
     * 正常可用，可加入
     */
    NORMAL(1),

    /**
     * 群成员已满
     */
    FULL(2);

    private int code;

    public int getCode() {
        return code;
    }

    GroupStatusEnum(int code) {
        this.code = code;
    }

    public boolean match(int code) {
        return Objects.equals(this.code, code);
    }
}
