package com.bxm.localnews.im.enums;

import com.bxm.newidea.component.tools.StringUtils;

public enum ObjectNameEnum {
    /**
     * 文本消息类型
     */
    TEXT_MESSAGE("RC:TxtMsg"),
    /**
     * 图片消息类型
     */
    IMG_MESSAGE("RC:ImgMsg"),
    /**
     * 新人招呼消息
     */
    SAY_HELLO("LN:SayHello"),
    /**
     * 在指定时间插入小纸条消息
     */
    REPLY_PAPER_TAPE("LN:ReplyPaperTape"),
    /**
     * 实时共享位置开始消息
     */
    RL_START("RC:RLStart"),
    /**
     * 实时位置共享的加入消息
     */
    RL_JOIN("RC:RLJoin"),
    /**
     * 实时位置共享的用户退出消息
     */
    RL_QUIT("RC:RLQuit"),
    /**
     * 实时共享位置开始消息
     */
    RL_END("RC:RLEnd"),
    /**
     * 位置消息
     */
    LBS_MSG("RC:LBSMsg"),
    /**
     * 群组保活消息
     */
    HEART_BEAT("LN:HeartBeat"),
    /**
     * 帖子消息
     */
    POST_MESSAGE("LN:SharePost"),

    /**
     * 群组红包
     */
    CHAT_ROOM_RED_PACKET("LN:RedPacket"),
    ;

    public String getObjectName() {
        return objectName;
    }

    private String objectName;


    ObjectNameEnum(String objectName) {
        this.objectName = objectName;
    }

    public static ObjectNameEnum getSendEnum(String objectName) {
        ObjectNameEnum[] values = ObjectNameEnum.values();
        for (ObjectNameEnum value : values) {
            if (StringUtils.equals(value.getObjectName(), objectName)) {
                return value;
            }
        }
        return null;
    }
}
