package com.bxm.localnews.im.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @author gonzo
 * @date 2021-03-05 15:23
 **/
public enum PushContentTypeEnum {

    // 内容类型 0: 文本; 1: 帖子; 2: 图片; 3: 自定义

    NONE((byte) -1),

    TEXT((byte) 0),

    POST((byte) 1),

    IMG((byte) 2),

    COSTUME((byte) 3),
    ;


    private byte type;

    PushContentTypeEnum(byte type) {
        this.type = type;
    }

    public static PushContentTypeEnum getByType(Byte type) {
        Optional<PushContentTypeEnum> any = Arrays.stream(PushContentTypeEnum.values())
                .filter(p -> Objects.equals(type, p.type))
                .findAny();

        return any.orElse(NONE);
    }

    public byte getType() {
        return type;
    }
}
