package com.bxm.localnews.im.enums;

import java.util.Objects;

/**
 * 红包类型
 *
 * @author Gonzo
 * @date 2019-10-29 18:43
 */
public enum RedPacketTypeEnum {

    GROUP(1, "群组红包"),

    /**
     * 冗余设计，暂时用不到
     */
    PERSONAL(2, "个人红包");

    private int type;

    private String des;

    RedPacketTypeEnum(int type, String des) {
        this.type = type;
        this.des = des;
    }

    public int getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    public static RedPacketTypeEnum getByType(Integer type) {
        if (Objects.nonNull(type)) {
            for (RedPacketTypeEnum value : RedPacketTypeEnum.values()) {
                if (value.type == type) {
                    return value;
                }
            }
        }
        return null;
    }

}
