package com.bxm.localnews.im.enums;

import java.util.Objects;

/**
 * 红包可领取状态
 *
 * @author liujia
 * @date 9/26/21 3:52 PM
 **/
public enum RedpacketStatusEnum {

    /**
     * 未到时间，不可领取
     */
    WAIT(0, "别着急，还没到时间"),

    /**
     * 可领取状态
     */
    RECEIVE(1, "开仓放粮，普天同庆"),

    /**
     * 领取结束
     */
    FINISH(2, "手慢了，粮食派完了"),

    /**
     * 不可领取
     */
    CLOSE(3, "红包已下线"),
    ;

    private int code;

    private String content;

    public int getCode() {
        return code;
    }

    public String getContent() {
        return content;
    }

    RedpacketStatusEnum(int code, String content) {
        this.code = code;
        this.content = content;
    }

    public boolean match(int code) {
        return Objects.equals(this.code, code);
    }
}
