package com.bxm.localnews.im.group;

import com.bxm.localnews.im.enums.GroupActionEnum;
import com.bxm.newidea.component.bo.Message;

/**
 * 群组相关操作，记录对应的操作历史
 *
 * @author liujia
 * @date 9/18/21 11:13 AM
 **/
public interface GroupActionService {

    /**
     * 设置群组成员为屏蔽状态
     *
     * @param groupId 群组ID
     * @param userId  成员ID
     * @return 操作结果
     */
    Message setGroupMemberBlack(Long groupId, Long userId);

    /**
     * 保存群组操作历史
     *
     * @param action     操作动作
     * @param groupId    群组ID
     * @param relationId 关联的业务ID
     * @param userId     操作的目标用户
     */
    void saveHistory(GroupActionEnum action, Long groupId, Long relationId, Long userId);
}
