package com.bxm.localnews.im.group;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.localnews.im.dto.group.ImCrumbDTO;
import com.bxm.localnews.im.dto.group.ImGroupInfoDTO;
import com.bxm.localnews.im.param.group.BaseGroupParam;

/**
 * 群组相关的组合接口
 *
 * @author liujia
 * @date 9/17/21 3:53 PM
 **/
public interface GroupCompositeService {

    /**
     * 获取群组的详细信息
     *
     * @param param 群组参数
     * @return 群组详细信息
     */
    ImGroupInfoDTO get(BaseGroupParam param);

    /**
     * 获取地区配置的本地圈群组入口
     *
     * @param param 地区参数
     * @return 本地圈面包块信息
     */
    ImCrumbDTO getCrumb(BaseAreaCodeParam param);
}
