package com.bxm.localnews.im.group;

import com.bxm.localnews.im.dto.group.GroupMemberListItemDTO;
import com.bxm.localnews.im.dto.group.MemberInfoDTO;
import com.bxm.localnews.im.enums.GroupMemberTypeEnum;
import com.bxm.localnews.im.param.group.*;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;

import java.util.List;

/**
 * 群组成员相关接口
 *
 * @author liujia
 * @date 9/17/21 2:21 PM
 **/
public interface GroupMemberService {

    /**
     * 加入群聊
     *
     * @param param 请求参数
     * @return 加入结果
     */
    Message executeJoin(JoinGroupParam param);

    /**
     * 从群聊中增加一定的虚拟用户，包括群管理员账号
     *
     * @param groupId   群组ID
     * @param groupName 群组名称
     * @param num       添加的虚拟用户数量
     * @return 操作结果
     */
    Message addVirtualMember(Long groupId, String groupName, Integer num);

    /**
     * 添加用户到群
     *
     * @param groupId    群组ID
     * @param groupName  群组名称
     * @param userId     用户ID
     * @param memberType 群成员类型
     */
    Message addMember(Long groupId, String groupName, Long userId, GroupMemberTypeEnum memberType);

    /**
     * 离开群聊
     *
     * @param param 处理参数
     * @return 离开结果
     */
    Message left(BaseGroupParam param);

    /**
     * 获取群组内所有成员的用户ID
     *
     * @param param 群组参数
     * @return 群成员ID，客户端根据ID获取用户信息
     */
    List<MemberInfoDTO> getAllMember(BaseGroupParam param);

    /**
     * 设置群组消息免打扰
     *
     * @param param 群消息
     * @return 设置结果
     */
    Message setMute(GroupMuteParam param);

    /**
     * 分页查询群组成员信息，用于管理后台
     *
     * @param param 查询参数
     * @return 群组成员信息
     */
    IPageModel<GroupMemberListItemDTO> queryByPage(GroupMemberQueryParam param);

    /**
     * 运营管理后台对群组成员进行各种操作
     *
     * @param param 操作参数
     * @return 处理结果
     */
    Message executeMemberAction(GroupMemberActionParam param);
}
