package com.bxm.localnews.im.group;

import com.bxm.localnews.im.dto.group.GroupNoticeDTO;
import com.bxm.localnews.im.param.group.GroupNoticeChangeParam;
import com.bxm.newidea.component.bo.Message;

/**
 * 群公告相关接口
 *
 * @author liujia
 * @date 9/17/21 2:24 PM
 **/
public interface GroupNoticeService {

    /**
     * 设置群公告，并推送消息到对应的群组
     *
     * @param param 公告设置参数
     * @return 设置结果
     */
    Message setNotice(GroupNoticeChangeParam param);

    /**
     * 查询当前群聊的可用群通知
     *
     * @param groupId 群组ID
     * @return 群组消息内容，如果不存在则返回空
     */
    GroupNoticeDTO getEnableNotice(Long groupId);
}
