package com.bxm.localnews.im.group;

import com.bxm.localnews.im.dto.group.GroupManageListItemDTO;
import com.bxm.localnews.im.dto.group.GroupRuntimeInfoDTO;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.param.group.ChangeEnableParam;
import com.bxm.localnews.im.param.group.ComplainGroupParam;
import com.bxm.localnews.im.param.group.GroupManageQueryParam;
import com.bxm.localnews.im.param.group.SaveGroupParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;

/**
 * 群组基础信息接口
 *
 * @author liujia
 * @date 9/17/21 2:20 PM
 **/
public interface GroupService {

    /**
     * 后台分页查询群组列表
     *
     * @param param 查询参数
     * @return 分页结果
     */
    IPageModel<GroupManageListItemDTO> query(GroupManageQueryParam param);

    /**
     * 变更群组状态
     *
     * @param param 处理参数
     * @return 处理结果
     */
    Message changeStatus(ChangeEnableParam param);

    /**
     * 变更群组的全员禁言状态
     *
     * @param param 操作参数
     * @return 处理结果
     */
    Message changeGlobalMute(ChangeEnableParam param);

    /**
     * 创建或更新群组消息
     *
     * @param param 创建参数
     * @return 处理结果
     */
    Message saveOrUpdate(SaveGroupParam param);

    /**
     * 投诉群组
     *
     * @param param 投诉参数
     * @return 投诉结果
     */
    Message complain(ComplainGroupParam param);

    /**
     * 获取分组实体
     *
     * @param groupId 分组ID
     * @return 分组实体信息
     */
    ImGroupEntity getGroupEntity(Long groupId);

    /**
     * 群组实时数据
     *
     * @param groupId 群组ID
     * @return 群组实时信息
     */
    GroupRuntimeInfoDTO loadGroupRuntimeInfo(Long groupId);

    /**
     * 重新加载群组实时数据
     *
     * @param groupId 群组ID
     */
    GroupRuntimeInfoDTO reloadRuntimeCache(Long groupId);
}
