package com.bxm.localnews.im.group;

import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.entity.group.ImGroupTotalEntity;
import com.bxm.newidea.component.bo.Message;

/**
 * 群组统计服务接口
 *
 * @author liujia
 * @date 9/17/21 3:38 PM
 **/
public interface GroupTotalService {

    /**
     * 初始化统计数据
     *
     * @param entity 群组信息
     */
    void init(ImGroupEntity entity);

    /**
     * 重置群组可参与最大人数
     *
     * @param groupId      群组ID
     * @param maxMemberNum 群组最多加入人数
     */
    void resetMaxMember(Long groupId, Integer maxMemberNum);

    /**
     * 增加群的参与人数
     *
     * @param groupId 群组ID
     * @return 添加结果
     */
    Message addMember(Long groupId);

    /**
     * 添加群组参与人数
     *
     * @param groupId 群组ID
     * @param num     参与人数量
     * @return 操作结果
     */
    Message addMember(Long groupId, Integer num);

    /**
     * 查询群组统计数据
     *
     * @param groupId 群组ID
     * @return 汇总数据
     */
    ImGroupTotalEntity getTotal(Long groupId);

    /**
     * 发放完毕一个红包，增加红包统计数据和粮食统计数据
     *
     * @param groupId  群组ID
     * @param grainNum 发放的粮食总量
     */
    void addRedpacket(Long groupId, Integer grainNum);
}
