package com.bxm.localnews.im.group.impl;

import com.bxm.egg.message.utils.AdminUtils;
import com.bxm.localnews.im.domain.group.ImGroupActionHistoryMapper;
import com.bxm.localnews.im.domain.group.ImGroupBlackMapper;
import com.bxm.localnews.im.entity.group.ImGroupActionHistoryEntity;
import com.bxm.localnews.im.entity.group.ImGroupBlackEntity;
import com.bxm.localnews.im.enums.GroupActionEnum;
import com.bxm.localnews.im.group.GroupActionService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * @author liujia
 * @date 9/18/21 11:14 AM
 **/
@AllArgsConstructor
@Service
@Slf4j
public class GroupActionServiceImpl implements GroupActionService {

    private ImGroupBlackMapper imGroupBlackMapper;

    private ImGroupActionHistoryMapper imGroupActionHistoryMapper;

    @Override
    public Message setGroupMemberBlack(Long groupId, Long userId) {
        ImGroupBlackEntity blackEntity = new ImGroupBlackEntity();
        blackEntity.setId(SequenceHolder.nextLongId());
        blackEntity.setCreateTime(LocalDateTime.now());
        blackEntity.setEnable(1);
        blackEntity.setGroupId(groupId);
        blackEntity.setUserId(userId);

        saveHistory(GroupActionEnum.KICK_OUT, groupId, blackEntity.getId(), userId);

        return Message.build(imGroupBlackMapper.insert(blackEntity));
    }

    @Override
    public void saveHistory(GroupActionEnum action, Long groupId, Long relationId, Long userId) {
        ImGroupActionHistoryEntity historyEntity = new ImGroupActionHistoryEntity();
        historyEntity.setGroupId(groupId);
        historyEntity.setAction(action.getCode());
        historyEntity.setRelationId(relationId);
        historyEntity.setTargetUserId(userId);

        historyEntity.setCreateTime(LocalDateTime.now());
        historyEntity.setId(SequenceHolder.nextLongId());
        historyEntity.setOperator(AdminUtils.getAdminUserId());

        imGroupActionHistoryMapper.insert(historyEntity);
    }
}
