package com.bxm.localnews.im.group.impl;

import com.bxm.localnews.im.domain.group.ImGroupMapper;
import com.bxm.localnews.im.domain.group.ImGroupMemberMapper;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.group.GroupMemberHeadImgService;
import com.bxm.localnews.im.utils.MakeGroupHeadPicUtil;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lowi
 * @date 2021/10/12 20:13
 */
@AllArgsConstructor
@Service
@Slf4j
public class GroupMemberHeadImgServiceImpl implements GroupMemberHeadImgService {

    private ImGroupMemberMapper imGroupMemberMapper;

    private ImGroupMapper imGroupMapper;

    private MakeGroupHeadPicUtil makeGroupHeadPicUtil;

    @Override
    @Async
    public void groupHeadImgSplicing(Long groupId) {
        log.debug("触发用户进群生成九宫格图片：groupId{}", groupId);
        List<ImGroupMemberEntity> imGroupMemberEntities = imGroupMemberMapper.queryMember(groupId, 1, null, 9);

        imGroupMemberEntities = imGroupMemberEntities.stream().filter(imGroupMemberEntity ->
                StringUtils.isNotBlank(imGroupMemberEntity.getHeadImg())).collect(Collectors.toList());
        List<String> headImgs = imGroupMemberEntities.stream().map(ImGroupMemberEntity::getHeadImg).collect(Collectors.toList());

        if (imGroupMemberEntities.isEmpty()) {
            return;
        }

        String groupHeadImg = makeGroupHeadPicUtil.getCombinationOfhead(headImgs, groupId + "groupHeadImg");

        if (groupHeadImg != null) {
            ImGroupEntity imGroupEntity = new ImGroupEntity();
            imGroupEntity.setId(groupId);
            imGroupEntity.setImgUrl(groupHeadImg);

            imGroupMapper.updateById(imGroupEntity);
            log.debug("触发用户进群生成九宫格图片：imGroupEntity,{}", imGroupEntity);
        }

    }

}
