package com.bxm.localnews.im.group.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.message.dto.LocationDTO;
import com.bxm.egg.message.integration.LocationIntegrationService;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.integration.VirtualUserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.foundation.user.facade.dto.VirtualUserDTO;
import com.bxm.localnews.im.bo.GroupInfoBO;
import com.bxm.localnews.im.domain.group.ImGroupMapper;
import com.bxm.localnews.im.domain.group.ImGroupMemberMapper;
import com.bxm.localnews.im.dto.group.GroupMemberListItemDTO;
import com.bxm.localnews.im.dto.group.GroupRuntimeInfoDTO;
import com.bxm.localnews.im.dto.group.MemberInfoDTO;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.enums.GroupActionEnum;
import com.bxm.localnews.im.enums.GroupMemberStatusEnum;
import com.bxm.localnews.im.enums.GroupMemberTypeEnum;
import com.bxm.localnews.im.enums.GroupStatusEnum;
import com.bxm.localnews.im.group.GroupActionService;
import com.bxm.localnews.im.group.GroupMemberService;
import com.bxm.localnews.im.group.GroupService;
import com.bxm.localnews.im.group.GroupTotalService;
import com.bxm.localnews.im.param.group.*;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.bxm.localnews.im.constant.LogicGroupConstant.GROUP_RUN_TIME_INFO;

/**
 * @author liujia
 * @date 9/17/21 4:18 PM
 **/
@Service
@Slf4j
@AllArgsConstructor
public class GroupMemberServiceImpl implements GroupMemberService {

    private ImGroupMemberMapper imGroupMemberMapper;

    private GroupService groupService;

    private ImGroupMapper imGroupMapper;

    private UserIntegrationService userIntegrationService;

    private GroupTotalService groupTotalService;

    private IMSDKAdapter imsdkAdapter;

    private LocationIntegrationService locationIntegrationService;

    private VirtualUserIntegrationService virtualUserIntegrationService;

    private GroupActionService groupActionService;

    @Override
    public Message executeJoin(JoinGroupParam param) {
        ImGroupEntity groupEntity = choiceEnableGroup(param);

        if (null != groupEntity) {
            // 添加成员
            Message message = addMember(groupEntity.getId(), groupEntity.getName(), param.getUserId(), GroupMemberTypeEnum.NORMAL);

            if (message.isSuccess()) {
                GroupRuntimeInfoDTO runtimeInfoDTO = groupService.loadGroupRuntimeInfo(groupEntity.getId());

                message.addParam(GROUP_RUN_TIME_INFO, runtimeInfoDTO);
            }
            return message;
        }

        return Message.build(false, "群人数已满,请等待管理员创建新群");
    }

    @Override
    public Message addVirtualMember(Long groupId, String groupName, Integer num) {
        List<Long> virtualUserIdList = Lists.newArrayList();

        if (num > 1) {
            List<VirtualUserDTO> userDTOList = virtualUserIntegrationService.getRandom(num);
            virtualUserIdList.addAll(userDTOList.stream().map(VirtualUserDTO::getUserId).collect(Collectors.toList()));
        }

        for (Long virtualUserId : virtualUserIdList) {
            addMember(groupId, groupName, virtualUserId, GroupMemberTypeEnum.VIRTUAL);
        }


        return Message.build();
    }

    /**
     * 选择一个可用的群让用户加入
     *
     * @param param 加群参数
     * @return 可用的群信息
     */
    private ImGroupEntity choiceEnableGroup(JoinGroupParam param) {

        if (null != param.getGroupId()) {
            ImGroupEntity groupEntity = groupService.getGroupEntity(param.getGroupId());
            if (null != groupEntity
                    && Objects.equals(groupEntity.getStatus(), GroupStatusEnum.NORMAL.getCode())
                    && Objects.equals(groupEntity.getEnable(), 1)) {
                return groupEntity;
            }
        }

        List<GroupInfoBO> groupList = imGroupMapper.getEnableGroupByArea(param.getAreaCode(), param.getUserId());

        for (GroupInfoBO groupInfoBO : groupList) {
            if (GroupStatusEnum.NORMAL.match(groupInfoBO.getStatus()) && groupInfoBO.getCurrentNum() < groupInfoBO.getMaxNum()) {
                ImGroupEntity finalGroup = new ImGroupEntity();
                finalGroup.setId(groupInfoBO.getGroupId());
                finalGroup.setName(groupInfoBO.getGroupName());
                return finalGroup;
            }
        }

        return null;
    }

    @Override
    public Message addMember(Long groupId, String groupName, Long userId, GroupMemberTypeEnum memberType) {
        ImGroupMemberEntity memberInfo = imGroupMemberMapper.getMemberInfo(groupId, userId);
        if (memberInfo != null) {
            log.info("用户[{}]已经在[{}]中了", userId, groupId);

            ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
            updateEntity.setId(memberInfo.getId());
            updateEntity.setStatus(GroupMemberStatusEnum.NORAML.getCode());

            imGroupMemberMapper.updateById(updateEntity);

            // 重新加入群聊
            Message message = imsdkAdapter.joinGroup(groupId, groupName, userId);
            if (!message.isSuccess()) {
                log.error("用户[{}]加入群聊失败，失败原因：{}", userId, message.getLastMessage());
            }

            // 重构缓存
            groupService.reloadRuntimeCache(groupId);

            return Message.build();
        }

        // 扣除参与人次
        Message message = groupTotalService.addMember(groupId);

        if (message.isSuccess()) {
            UserInfoBean userInfo = userIntegrationService.getUserInfo(userId);
            if (GroupMemberTypeEnum.VIRTUAL.equals(memberType)) {
                userInfo = virtualUserIntegrationService.loadVirtualUser(userId);
            }

            ImGroupMemberEntity memberEntity = new ImGroupMemberEntity();
            memberEntity.setId(SequenceHolder.nextLongId());
            memberEntity.setGroupId(groupId);
            memberEntity.setUserId(userId);
            memberEntity.setNickName(userInfo.getNickname());
            memberEntity.setHeadImg(userInfo.getHeadImg());
            memberEntity.setUserType(memberType.getCode());
            memberEntity.setJoinTime(new Date());
            memberEntity.setStatus(GroupMemberStatusEnum.NORAML.getCode());

            // 记录群组信息
            imGroupMemberMapper.insert(memberEntity);

            // 调用API，将用户加入到群组
            message = imsdkAdapter.joinGroup(groupId, groupName, userId);
            // 重构缓存
            groupService.reloadRuntimeCache(groupId);
        }


        return message;
    }

    @Override
    public Message left(BaseGroupParam param) {
        ImGroupMemberEntity memberEntity = new ImGroupMemberEntity();
        memberEntity.setGroupId(param.getGroupId());
        memberEntity.setUserId(param.getUserId());
        memberEntity.setStatus(GroupMemberStatusEnum.LEFT.getCode());
        memberEntity.setLeftTime(new Date());

        imGroupMemberMapper.updateByGroupIdAndUserId(memberEntity);

        // 可参与人+1
        groupTotalService.addMember(memberEntity.getGroupId(), -1);

        return imsdkAdapter.quitGroup(param.getGroupId(), param.getUserId());
    }

    @Override
    public List<MemberInfoDTO> getAllMember(BaseGroupParam param) {
        return imGroupMemberMapper.queryAllMember(param.getGroupId());
    }

    @Override
    public Message setMute(GroupMuteParam param) {
        ImGroupMemberEntity memberEntity = new ImGroupMemberEntity();
        memberEntity.setGroupId(param.getGroupId());
        memberEntity.setUserId(param.getUserId());
        memberEntity.setMuted(param.getMute() ? 1 : 0);

        return Message.build(imGroupMemberMapper.updateByGroupIdAndUserId(memberEntity));
    }

    @Override
    public IPageModel<GroupMemberListItemDTO> queryByPage(GroupMemberQueryParam param) {
        Page<GroupMemberListItemDTO> page = new Page<>(param.getPageNum(), param.getPageSize());
        IPage<GroupMemberListItemDTO> result = imGroupMemberMapper.queryMemberByPage(page, param);

        for (GroupMemberListItemDTO record : result.getRecords()) {
            LocationDTO location = locationIntegrationService.getLocationByGeocode(record.getAreaCode());
            record.setAreaName(location.getName());
        }

        return PlusPageModelDTO.build(result);
    }

    @Override
    public Message executeMemberAction(GroupMemberActionParam param) {
        Message message = Message.build();
        GroupActionEnum actionEnum = GroupActionEnum.getByCode(param.getAction());

        if (null != actionEnum) {
            switch (actionEnum) {
                case BLOCK:
                    return block(param);
                case UNBLOCK:
                    return unblock(param);
                case KICK_OUT:
                    return kickOut(param);
                default:
            }
        }

        return message;
    }

    private Message unblock(GroupMemberActionParam param) {
        ImGroupMemberEntity memberEntity = imGroupMemberMapper.selectById(param.getRecordId());

        ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
        updateEntity.setId(param.getRecordId());
        updateEntity.setBlockStatus(0);
        updateEntity.setBlockTime(null);
        updateEntity.setModifyTime(new Date());

        groupActionService.saveHistory(GroupActionEnum.UNBLOCK,
                memberEntity.getGroupId(),
                memberEntity.getId(),
                memberEntity.getUserId());

        Message message = Message.build(imGroupMemberMapper.updateById(updateEntity));

        if (message.isSuccess()) {
            imsdkAdapter.unblockGroupMember(memberEntity.getGroupId(), memberEntity.getUserId());
        }

        return message;
    }

    private Message block(GroupMemberActionParam param) {
        ImGroupMemberEntity memberEntity = imGroupMemberMapper.selectById(param.getRecordId());

        ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
        updateEntity.setId(param.getRecordId());
        updateEntity.setBlockStatus(1);
        if (null == param.getBlockTime()) {
            // 为空就设置为永久禁言
            updateEntity.setBlockTime(DateUtils.addField(new Date(), Calendar.YEAR, 100));
        } else {
            updateEntity.setBlockTime(param.getBlockTime());
        }
        updateEntity.setModifyTime(new Date());

        groupActionService.saveHistory(GroupActionEnum.BLOCK,
                memberEntity.getGroupId(),
                memberEntity.getId(),
                memberEntity.getUserId());


        Message message = Message.build(imGroupMemberMapper.updateById(updateEntity));

        if (message.isSuccess()) {
            imsdkAdapter.blockGroupMember(memberEntity.getGroupId(), memberEntity.getUserId(), updateEntity.getBlockTime());
        }

        return message;
    }

    private Message kickOut(GroupMemberActionParam param) {
        ImGroupMemberEntity memberEntity = imGroupMemberMapper.selectById(param.getRecordId());

        ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
        updateEntity.setId(param.getRecordId());
        updateEntity.setStatus(GroupMemberStatusEnum.KICK_OUT.getCode());
        updateEntity.setLeftTime(new Date());
        updateEntity.setModifyTime(new Date());

        imGroupMemberMapper.updateById(updateEntity);

        // 可参与人+1
        groupTotalService.addMember(memberEntity.getGroupId(), -1);
        // 记录到黑名单，防止后续再加入
        groupActionService.setGroupMemberBlack(memberEntity.getGroupId(), memberEntity.getUserId());

        return imsdkAdapter.quitGroup(memberEntity.getGroupId(), memberEntity.getUserId());
    }
}
