package com.bxm.localnews.im.group.impl;

import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.config.GroupProperties;
import com.bxm.localnews.im.domain.group.ImGroupMemberMapper;
import com.bxm.localnews.im.domain.group.ImGroupNoticeMapper;
import com.bxm.localnews.im.dto.group.GroupNoticeDTO;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.entity.group.ImGroupNoticeEntity;
import com.bxm.localnews.im.enums.GroupMemberTypeEnum;
import com.bxm.localnews.im.group.GroupNoticeService;
import com.bxm.localnews.im.param.group.GroupNoticeChangeParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.thirdpart.message.TextMessage;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author liujia
 * @date 9/17/21 7:21 PM
 **/
@Service
@Slf4j
@AllArgsConstructor
public class GroupNoticeServiceImpl implements GroupNoticeService {

    private ImGroupNoticeMapper imGroupNoticeMapper;

    private IMSDKAdapter imsdkAdapter;

    private GroupProperties groupProperties;

    private ImGroupMemberMapper imGroupMemberMapper;

    private UserIntegrationService userIntegrationService;

    @Override
    public Message setNotice(GroupNoticeChangeParam param) {
        imGroupNoticeMapper.disableHistory(param.getGroupId());


        ImGroupNoticeEntity saveEntity = new ImGroupNoticeEntity();
        saveEntity.setId(SequenceHolder.nextLongId());
        saveEntity.setContent(param.getContent());
        saveEntity.setCreateTime(new Date());
        saveEntity.setEnable(1);
        saveEntity.setGroupId(param.getGroupId());

        // 将管理员设置为发布人
        List<ImGroupMemberEntity> imGroupMemberEntities = imGroupMemberMapper.queryMember(null,
                GroupMemberTypeEnum.MANAGE.getCode(),
                null,
                1);
        if (imGroupMemberEntities.size() > 0) {
            saveEntity.setPublisher(imGroupMemberEntities.get(0).getUserId());
        } else {
            saveEntity.setPublisher(groupProperties.getManageUserId());
        }

        imGroupNoticeMapper.insert(saveEntity);

        return imsdkAdapter.sendGroupMessage(saveEntity.getGroupId(),
                groupProperties.getManageUserId(),
                TextMessage.builder().content(param.getContent()).build());
    }

    @Override
    public GroupNoticeDTO getEnableNotice(Long groupId) {
        ImGroupNoticeEntity enableNotice = imGroupNoticeMapper.getEnableNotice(groupId);

        if (null == enableNotice) {
            return null;
        }

        UserInfoBean userInfo = userIntegrationService.getUserInfo(enableNotice.getPublisher());

        if (log.isDebugEnabled()) {
            log.debug("群管理消息的发布人为：{} - {}", enableNotice.getPublisher(), userInfo);
        }

        return GroupNoticeDTO.builder()
                .content(enableNotice.getContent())
                .publishTime(enableNotice.getCreateTime())
                .publisherNickName(userInfo.getNickname())
                .publisherHeadImg(userInfo.getHeadImg())
                .build();
    }
}
