package com.bxm.localnews.im.group.impl;

import com.bxm.localnews.im.domain.group.ImGroupTotalMapper;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.entity.group.ImGroupTotalEntity;
import com.bxm.localnews.im.group.GroupTotalService;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author liujia
 * @date 9/17/21 3:38 PM
 **/
@Service
@AllArgsConstructor
public class GroupTotalServiceImpl implements GroupTotalService {

    private ImGroupTotalMapper imGroupTotalMapper;

    @Override
    public void init(ImGroupEntity entity) {
        ImGroupTotalEntity totalEntity = new ImGroupTotalEntity();
        totalEntity.setGroupId(entity.getId());
        totalEntity.setMaxMemberNum(entity.getMemberMaxNum());
        // 初始化固定为2，管理员、活动人员进行占位
        totalEntity.setCurrentMemberNum(0);
        totalEntity.setRedPackageNum(0);
        totalEntity.setGrainNum(0);
        totalEntity.setCreateTime(new Date());

        imGroupTotalMapper.insert(totalEntity);
    }

    @Override
    public void resetMaxMember(Long groupId, Integer maxMemberNum) {
        ImGroupTotalEntity totalEntity = new ImGroupTotalEntity();
        totalEntity.setGroupId(groupId);
        totalEntity.setMaxMemberNum(maxMemberNum);

        imGroupTotalMapper.updateById(totalEntity);
    }

    @Override
    public Message addMember(Long groupId) {
        return addMember(groupId, 1);
    }

    @Override
    public Message addMember(Long groupId, Integer num) {
        return Message.build(imGroupTotalMapper.addMember(groupId, num));
    }

    @Override
    public ImGroupTotalEntity getTotal(Long groupId) {
        return imGroupTotalMapper.selectById(groupId);
    }

    @Override
    public void addRedpacket(Long groupId, Integer grainNum) {
        ImGroupTotalEntity entity = new ImGroupTotalEntity();
        entity.setGroupId(groupId);
        entity.setGrainNum(grainNum);
        entity.setRedPackageNum(1);

        imGroupTotalMapper.addCount(entity);
    }
}
